local PANEL = {};

// link to class
function PANEL:LinkToClass( cls )
	self.LinkedClass = cls;
	
end

// button.
function PANEL:Init( )
	// linked to
	self.LinkedClass = nil;
	
	// list layout.
	self.Layout = CtlListLayout_class:create( self );
	self.Layout:SetSpacing( 2 );

	// create the header.
	self.Header = CtlHeader_class:create( self.Layout:GetHandle() );
	self.Header:SetPos( 4, 4 );
	self.Header:SetSize( 128, 32 );
	self.Header:SetTitle( "Translation" );
	self.Layout:AddItem( self.Header );
	
	// create the body.
	self.Body = CtlBody_class:create( self.Layout:GetHandle() );
	self.Body:SetPos( 4, 4 );
	self.Body:SetSize( 128, 96 );
	self.Layout:AddItem( self.Body );
	
	
	// create a seperate layout inside the body.
	self.SliderLayout = CtlListLayout_class:create( self.Body:GetHandle() );
	self.SliderLayout:SetSpacing( 4 );
	
	// create x
	self.XSlider = CtlSlider_class:create( self.SliderLayout:GetHandle() );
	self.XSlider:SetText( "X" );
	self.XSlider:SetHorizontal( true );
	self.XSlider:SetRange( -256, 256 );
	self.XSlider:SetSnap( 32 );
	self.XSlider:SetSize( 128, 32 );
	self.XSlider:SetConVar( "vmf_ofs_x" );
	self.SliderLayout:AddItem( self.XSlider );
	
	// create y
	self.YSlider = CtlSlider_class:create( self.SliderLayout:GetHandle() );
	self.YSlider:SetText( "Y" );
	self.YSlider:SetHorizontal( true );
	self.YSlider:SetRange( -256, 256 );
	self.YSlider:SetSnap( 32 );
	self.YSlider:SetSize( 128, 32 );
	self.YSlider:SetConVar( "vmf_ofs_y" );
	self.SliderLayout:AddItem( self.YSlider );
	
	// create z
	self.ZSlider = CtlSlider_class:create( self.SliderLayout:GetHandle() );
	self.ZSlider:SetText( "Z" );
	self.ZSlider:SetHorizontal( true );
	self.ZSlider:SetRange( -256, 256 );
	self.ZSlider:SetSnap( 32 );
	self.ZSlider:SetSize( 128, 32 );
	self.ZSlider:SetConVar( "vmf_ofs_z" );
	self.SliderLayout:AddItem( self.ZSlider );
	
end



// perform layout
function PANEL:PerformLayout( )
	// width/height
	local width, height = self:GetSize();
	
	// force an update of the slider layout.
	self.SliderLayout:SetPos( 0, 4 );
	self.SliderLayout:SetSize( width, height );
	
	// fetch the height.
	local body_height = self.SliderLayout:Update();

	// size the body.
	self.Body:SetSize( width, body_height + 8 );
	
	
	// position the layout.
	self.Layout:SetPos( 0, 0 );
	self.Layout:SetSize( width, height );

	// lets go ahead and force a layout update.
	local newheight = self.Layout:Update();
	
	// set our size
	self:SetSize( width, newheight );
	
end


// draw
function PANEL:Paint( )
	//
	return true;
	
end

// register
vgui.Register( "ctl_translation_element", PANEL, "Panel" );




// create app framework control.
CtlTranslationElement_class 	= Control_class:create( nil, false, "ctl_translation_element" );

